#!/usr/env python
import sys
from glob import glob
import os.path
def convert(infile,outfile):
	from bmdl import BRenderModel
	model=BRenderModel(infile)
	fop=open(outfile,'w')
	fop.write('#OBJ Created by bmdl2obj v0.2\nSource file: %s\n' % (infile))
	for x,y,z,u,v in model.verts:
		fop.write('v %0.8f %0.8f %0.8f\n' % (x,y,z))
	for x,y,z,u,v in model.verts:
		fop.write('vt %0.8f %0.8f\n' % (u,v))
	for v1,v2,v3 in model.tris:
		fop.write('f %i/%i %i/%i %i/%i\n' % (v1+1,v1+1,v2+1,v2+1,v3+1,v3+1))
if len(sys.argv)<2:
	print 'Usage: bmdl2obj.py <in.bmdl> [out.obj]'
if len(sys.argv)==3:
	convert(sys.argv[1],sys.argv[2])
if len(sys.argv)==2:
	files=glob(sys.argv[1])
	for bmdl in files:
		print bmdl
		base,ext=os.path.splitext(bmdl)
		objname=base+'.obj'
		convert(bmdl,objname)

